               
C
C ======================================================================
C ============================ SUBROUTINE SXM ==========================
C ======================================================================
C
      SUBROUTINE SXM(PHI,OK)
C
C THIS SUBROUTINE CALCULATES THE FULL DAMAGE EFFECT TENSOR XM(I,J,K,L),
C ITS INVERSE, THE SIXTH RANK TENSOR XMPHI(I,J,K,L,M,N) AND THE 
C CONTRACTION XM(R,R,K,L). NOTE THAT THE FULL DAMAGE EFFECT TENSOR IS 
C SYMMETRIC.
C
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/XXX1/XM(3,3,3,3),XMINV(3,3,3,3),XMPHI(3,3,3,3,3,3),
     .            XMRR(3,3)
C
      REAL*8 PHI(3,3)
      CHARACTER PTYPE*30
      LOGICAL OK
      DATA ONE,TWO,FOUR,PTYPE/1.0D0,2.0D0,4.0D0,'MAXIMAL'/
C
      CST1=ONE-PHI(1,1)
      CST2=ONE-PHI(2,2)
      CST3=ONE-PHI(3,3)
      CST4=PHI(2,3)*PHI(2,3)*CST1
      CST5=PHI(1,3)*PHI(1,3)*CST2
      CST6=PHI(1,2)*PHI(1,2)*CST3
      CST7=TWO*PHI(1,2)*PHI(2,3)*PHI(1,3)
      DELTA=CST1*CST2*CST3-CST4-CST5-CST6-CST7
      XM(1,1,1,1)=(CST2*CST3-PHI(2,3)*PHI(2,3))/DELTA
      XM(1,1,1,3)=(PHI(1,2)*PHI(2,3)+PHI(1,3)*CST2)/(TWO*DELTA)
      XM(1,1,3,1)=XM(1,1,1,3)
      XM(3,1,1,1)=XM(1,1,1,3)
      XM(1,3,1,1)=XM(1,1,1,3)
      XM(1,1,1,2)=(PHI(1,3)*PHI(2,3)+PHI(1,2)*CST3)/(TWO*DELTA)
      XM(1,1,2,1)=XM(1,1,1,2)
      XM(1,2,1,1)=XM(1,1,1,2)
      XM(2,1,1,1)=XM(1,1,1,2)
      XM(2,2,2,2)=(CST1*CST3-PHI(1,3)*PHI(1,3))/DELTA
      XM(2,2,2,3)=(PHI(1,2)*PHI(1,3)+PHI(2,3)*CST1)/(TWO*DELTA)
      XM(2,2,3,2)=XM(2,2,2,3)
      XM(2,3,2,2)=XM(2,2,2,3)
      XM(3,2,2,2)=XM(2,2,2,3)
      XM(2,2,1,2)=XM(1,1,1,2)
      XM(2,2,2,1)=XM(2,2,1,2)
      XM(1,2,2,2)=XM(2,2,1,2)
      XM(2,1,2,2)=XM(2,2,1,2)
      XM(3,3,3,3)=(CST1*CST2-PHI(1,2)*PHI(1,2))/DELTA
      XM(3,3,2,3)=XM(2,2,2,3)
      XM(3,3,3,2)=XM(3,3,2,3)
      XM(2,3,3,3)=XM(3,3,2,3)
      XM(3,2,3,3)=XM(3,3,2,3)
      XM(3,3,1,3)=XM(1,1,1,3)
      XM(3,3,3,1)=XM(3,3,1,3)
      XM(3,1,3,3)=XM(3,3,1,3)
      XM(1,3,3,3)=XM(3,3,1,3)
      XM(2,3,2,3)=(CST1*CST3+CST1*CST2-PHI(1,3)*PHI(1,3)-PHI(1,2)*
     .             PHI(1,2))/(FOUR*DELTA)
      XM(2,3,3,2)=XM(2,3,2,3)
      XM(3,2,2,3)=XM(2,3,2,3)
      XM(3,2,3,2)=XM(2,3,2,3)
      XM(2,3,1,3)=(PHI(1,3)*PHI(2,3)+PHI(1,2)*CST3)/(FOUR*DELTA)
      XM(2,3,3,1)=XM(2,3,1,3)
      XM(3,2,1,3)=XM(2,3,1,3)
      XM(3,2,3,1)=XM(2,3,1,3)
      XM(3,1,2,3)=XM(2,3,1,3)
      XM(3,1,3,2)=XM(2,3,1,3)
      XM(1,3,2,3)=XM(2,3,1,3)
      XM(1,3,3,2)=XM(2,3,1,3)
      XM(2,3,1,2)=(PHI(1,2)*PHI(2,3)+PHI(1,3)*CST2)/(FOUR*DELTA)
      XM(2,3,2,1)=XM(2,3,1,2)
      XM(3,2,1,2)=XM(2,3,1,2)
      XM(3,2,2,1)=XM(2,3,1,2)
      XM(1,2,2,3)=XM(2,3,1,2)
      XM(1,2,3,2)=XM(2,3,1,2)
      XM(2,1,2,3)=XM(2,3,1,2)
      XM(2,1,3,2)=XM(2,3,1,2)
      XM(3,1,1,3)=(CST2*CST3+CST1*CST2-PHI(2,3)*PHI(2,3)-PHI(1,2)*
     .             PHI(1,2))/(FOUR*DELTA)
      XM(3,1,3,1)=XM(3,1,1,3)
      XM(1,3,1,3)=XM(3,1,1,3)
      XM(1,3,3,1)=XM(3,1,1,3)
      XM(3,1,1,2)=(PHI(1,2)*PHI(1,3)+PHI(2,3)*CST1)/(FOUR*DELTA)
      XM(3,1,2,1)=XM(3,1,1,2)
      XM(1,3,1,2)=XM(3,1,1,2)
      XM(1,3,2,1)=XM(3,1,1,2)
      XM(1,2,1,3)=XM(3,1,1,2)
      XM(1,2,3,1)=XM(3,1,1,2)
      XM(2,1,1,3)=XM(3,1,1,2)
      XM(2,1,3,1)=XM(3,1,1,2)
      XM(1,2,1,2)=(CST2*CST3+CST1*CST3-PHI(2,3)*PHI(2,3)-PHI(1,3)*
     .             PHI(1,3))/(FOUR*DELTA)
      XM(1,2,2,1)=XM(1,2,1,2)
      XM(2,1,1,2)=XM(1,2,1,2)
      XM(2,1,2,1)=XM(1,2,1,2)
C COMPUTE THE INVERSE OF TENSOR XM
      CALL DTENSOR_INVERSE(XM,XMINV,PTYPE,OK)
      IF(.NOT.OK)THEN
        PRINT*,'***************** SUBROUTINE SXM ****************'
        PRINT*,'Error computing inverse of XM'  
        RETURN
      ENDIF
C               
C CALCULATE THE SIXTH ORDER TENSOR PARTIAL OF M W.R.T. PHI
C
      P1=ONE-PHI(1,1)
      P2=ONE-PHI(2,2)
      P3=ONE-PHI(3,3)
      P4=PHI(2,3)*PHI(2,3)*P1
      P5=PHI(1,3)*PHI(1,3)*P2
      P6=PHI(1,2)*PHI(1,2)*P3
      P7=TWO*PHI(1,2)*PHI(2,3)*PHI(1,3)
      DT=P1*P2*P3-P4-P5-P6-P7
      D1=-P2*P3+PHI(2,3)**2
      D2=-P1*P3+PHI(1,3)**2
      D3=-P1*P2+PHI(1,2)**2
      D4=-TWO*(PHI(2,3)*P1+PHI(1,2)*PHI(1,3))
      D5=-TWO*(PHI(1,3)*P2+PHI(1,2)*PHI(2,3))
      D6=-TWO*(PHI(1,2)*P3+PHI(2,3)*PHI(1,3))
      X1=P2*P3-PHI(2,3)**2
      X2=P1*P3-PHI(1,3)**2
      X3=P1*P2-PHI(1,2)**2
      X4=PHI(1,2)*PHI(2,3)+PHI(1,3)*P2
      X5=PHI(1,3)*PHI(2,3)+PHI(1,2)*P3
      X6=PHI(1,2)*PHI(1,3)+PHI(2,3)*P1
      X7=P1*P3+P1*P2-PHI(1,3)**2-PHI(1,2)**2
      X8=P2*P3+P1*P2-PHI(2,3)**2-PHI(1,2)**2
      X9=P2*P3+P1*P3-PHI(2,3)**2-PHI(1,3)**2
C
      XMPHI(1,1,1,1,1,1)=-X1*D1/(DT*DT)
      XMPHI(1,1,1,1,2,2)=(-P3*DT-X1*D2)/(DT*DT)
      XMPHI(1,1,1,1,3,3)=(-P2*DT-X1*D3)/(DT*DT)
      XMPHI(1,1,1,1,2,3)=(-TWO*PHI(2,3)*DT-X1*D4)/(DT*DT)
      XMPHI(1,1,1,1,3,2)=XMPHI(1,1,1,1,2,3)
      XMPHI(1,1,1,1,3,1)=(-X1*D5)/(DT*DT)
      XMPHI(1,1,1,1,1,3)=XMPHI(1,1,1,1,3,1)
      XMPHI(1,1,1,1,1,2)=(-X1*D6)/(DT*DT)
      XMPHI(1,1,1,1,2,1)=XMPHI(1,1,1,1,1,2)
C
C
      XMPHI(2,2,2,2,1,1)=(-P3*DT-X2*D1)/(DT*DT)
      XMPHI(2,2,2,2,2,2)=(-X2*D2)/(DT*DT)
      XMPHI(2,2,2,2,3,3)=(-P1*DT-X2*D3)/(DT*DT)
      XMPHI(2,2,2,2,2,3)=(-X2*D4)/(DT*DT)
      XMPHI(2,2,2,2,3,2)=XMPHI(2,2,2,2,2,3)
      XMPHI(2,2,2,2,3,1)=(-TWO*PHI(1,3)*DT-X2*D5)/(DT*DT)
      XMPHI(2,2,2,2,1,3)=XMPHI(2,2,2,2,3,1)
      XMPHI(2,2,2,2,1,2)=(-X2*D6)/(DT*DT)
      XMPHI(2,2,2,2,2,1)=XMPHI(2,2,2,2,1,2)
C
C
      XMPHI(3,3,3,3,1,1)=(-P2*DT-X3*D1)/(DT*DT)
      XMPHI(3,3,3,3,2,2)=(-P1*DT-X3*D2)/(DT*DT)
      XMPHI(3,3,3,3,3,3)=(-X3*D3)/(DT*DT)
      XMPHI(3,3,3,3,2,3)=(-X3*D4)/(DT*DT)
      XMPHI(3,3,3,3,3,2)=XMPHI(3,3,3,3,2,3)
      XMPHI(3,3,3,3,3,1)=(-TWO*PHI(1,2)*DT-X3*D5)/(DT*DT)
      XMPHI(3,3,3,3,1,3)=XMPHI(3,3,3,3,3,1)
      XMPHI(3,3,3,3,1,2)=(-X3*D6)/(DT*DT)
      XMPHI(3,3,3,3,2,1)=XMPHI(3,3,3,3,1,2)
C
C
      XMPHI(1,1,1,3,1,1)=(-X4*D1)/(TWO*DT*DT)
      XMPHI(1,1,1,3,2,2)=(-PHI(1,3)*DT-X4*D2)/(TWO*DT*DT)
      XMPHI(1,1,1,3,3,3)=(-X4*D3)/(TWO*DT*DT)
      XMPHI(1,1,1,3,2,3)=(PHI(1,2)*DT-X4*D4)/(TWO*DT*DT)
      XMPHI(1,1,1,3,3,2)=XMPHI(1,1,1,3,2,3)
      XMPHI(1,1,1,3,3,1)=(P2*DT-X4*D5)/(TWO*DT*DT)
      XMPHI(1,1,1,3,1,3)=XMPHI(1,1,1,3,3,1)
      XMPHI(1,1,1,3,1,2)=(PHI(2,3)*DT-X4*D6)/(TWO*DT*DT)
      XMPHI(1,1,1,3,2,1)=XMPHI(1,1,1,3,1,2)
C
      XMPHI(1,1,3,1,1,1)=XMPHI(1,1,1,3,1,1)
      XMPHI(1,1,3,1,2,2)=XMPHI(1,1,1,3,2,2)
      XMPHI(1,1,3,1,3,3)=XMPHI(1,1,1,3,3,3)
      XMPHI(1,1,3,1,2,3)=XMPHI(1,1,1,3,2,3)
      XMPHI(1,1,3,1,3,2)=XMPHI(1,1,1,3,2,3)
      XMPHI(1,1,3,1,3,1)=XMPHI(1,1,1,3,3,1)
      XMPHI(1,1,3,1,1,3)=XMPHI(1,1,1,3,3,1)
      XMPHI(1,1,3,1,1,2)=XMPHI(1,1,1,3,1,2)
      XMPHI(1,1,3,1,2,1)=XMPHI(1,1,1,3,1,2)
C
      XMPHI(3,3,1,3,1,1)=XMPHI(1,1,1,3,1,1)
      XMPHI(3,3,1,3,2,2)=XMPHI(1,1,1,3,2,2)
      XMPHI(3,3,1,3,3,3)=XMPHI(1,1,1,3,3,3)
      XMPHI(3,3,1,3,2,3)=XMPHI(1,1,1,3,2,3)
      XMPHI(3,3,1,3,3,2)=XMPHI(1,1,1,3,2,3)
      XMPHI(3,3,1,3,3,1)=XMPHI(1,1,1,3,3,1)
      XMPHI(3,3,1,3,1,3)=XMPHI(1,1,1,3,3,1)
      XMPHI(3,3,1,3,1,2)=XMPHI(1,1,1,3,1,2)
      XMPHI(3,3,1,3,2,1)=XMPHI(1,1,1,3,1,2)
C
      XMPHI(3,3,3,1,1,1)=XMPHI(1,1,1,3,1,1)
      XMPHI(3,3,3,1,2,2)=XMPHI(1,1,1,3,2,2)
      XMPHI(3,3,3,1,3,3)=XMPHI(1,1,1,3,3,3)
      XMPHI(3,3,3,1,2,3)=XMPHI(1,1,1,3,2,3)
      XMPHI(3,3,3,1,3,2)=XMPHI(1,1,1,3,2,3)
      XMPHI(3,3,3,1,3,1)=XMPHI(1,1,1,3,3,1)
      XMPHI(3,3,3,1,1,3)=XMPHI(1,1,1,3,3,1)
      XMPHI(3,3,3,1,1,2)=XMPHI(1,1,1,3,1,2)
      XMPHI(3,3,3,1,2,1)=XMPHI(1,1,1,3,1,2)
C
      XMPHI(3,1,1,1,1,1)=XMPHI(1,1,1,3,1,1)
      XMPHI(3,1,1,1,2,2)=XMPHI(1,1,1,3,2,2)
      XMPHI(3,1,1,1,3,3)=XMPHI(1,1,1,3,3,3)
      XMPHI(3,1,1,1,2,3)=XMPHI(1,1,1,3,2,3)
      XMPHI(3,1,1,1,3,2)=XMPHI(1,1,1,3,2,3)
      XMPHI(3,1,1,1,3,1)=XMPHI(1,1,1,3,3,1)
      XMPHI(3,1,1,1,1,3)=XMPHI(1,1,1,3,3,1)
      XMPHI(3,1,1,1,1,2)=XMPHI(1,1,1,3,1,2)
      XMPHI(3,1,1,1,2,1)=XMPHI(1,1,1,3,1,2)
C
      XMPHI(3,1,3,3,1,1)=XMPHI(1,1,1,3,1,1)
      XMPHI(3,1,3,3,2,2)=XMPHI(1,1,1,3,2,2)
      XMPHI(3,1,3,3,3,3)=XMPHI(1,1,1,3,3,3)
      XMPHI(3,1,3,3,2,3)=XMPHI(1,1,1,3,2,3)
      XMPHI(3,1,3,3,3,2)=XMPHI(1,1,1,3,2,3)
      XMPHI(3,1,3,3,3,1)=XMPHI(1,1,1,3,3,1)
      XMPHI(3,1,3,3,1,3)=XMPHI(1,1,1,3,3,1)
      XMPHI(3,1,3,3,1,2)=XMPHI(1,1,1,3,1,2)
      XMPHI(3,1,3,3,2,1)=XMPHI(1,1,1,3,1,2)
C
      XMPHI(1,3,1,1,1,1)=XMPHI(1,1,1,3,1,1)
      XMPHI(1,3,1,1,2,2)=XMPHI(1,1,1,3,2,2)
      XMPHI(1,3,1,1,3,3)=XMPHI(1,1,1,3,3,3)
      XMPHI(1,3,1,1,2,3)=XMPHI(1,1,1,3,2,3)
      XMPHI(1,3,1,1,3,2)=XMPHI(1,1,1,3,2,3)
      XMPHI(1,3,1,1,3,1)=XMPHI(1,1,1,3,3,1)
      XMPHI(1,3,1,1,1,3)=XMPHI(1,1,1,3,3,1)
      XMPHI(1,3,1,1,1,2)=XMPHI(1,1,1,3,1,2)
      XMPHI(1,3,1,1,2,1)=XMPHI(1,1,1,3,1,2)
C
      XMPHI(1,3,3,3,1,1)=XMPHI(1,1,1,3,1,1)
      XMPHI(1,3,3,3,2,2)=XMPHI(1,1,1,3,2,2)
      XMPHI(1,3,3,3,3,3)=XMPHI(1,1,1,3,3,3)
      XMPHI(1,3,3,3,2,3)=XMPHI(1,1,1,3,2,3)
      XMPHI(1,3,3,3,3,2)=XMPHI(1,1,1,3,2,3)
      XMPHI(1,3,3,3,3,1)=XMPHI(1,1,1,3,3,1)
      XMPHI(1,3,3,3,1,3)=XMPHI(1,1,1,3,3,1)
      XMPHI(1,3,3,3,1,2)=XMPHI(1,1,1,3,1,2)
      XMPHI(1,3,3,3,2,1)=XMPHI(1,1,1,3,1,2)
C
C
      XMPHI(2,3,1,2,1,1)=XMPHI(1,1,1,3,1,1)/TWO
      XMPHI(2,3,1,2,2,2)=XMPHI(1,1,1,3,2,2)/TWO
      XMPHI(2,3,1,2,3,3)=XMPHI(1,1,1,3,3,3)/TWO
      XMPHI(2,3,1,2,2,3)=XMPHI(1,1,1,3,2,3)/TWO
      XMPHI(2,3,1,2,3,2)=XMPHI(1,1,1,3,2,3)/TWO
      XMPHI(2,3,1,2,3,1)=XMPHI(1,1,1,3,3,1)/TWO
      XMPHI(2,3,1,2,1,3)=XMPHI(1,1,1,3,3,1)/TWO
      XMPHI(2,3,1,2,1,2)=XMPHI(1,1,1,3,1,2)/TWO
      XMPHI(2,3,1,2,2,1)=XMPHI(1,1,1,3,1,2)/TWO
C
      XMPHI(2,3,2,1,1,1)=XMPHI(2,3,1,2,1,1)
      XMPHI(2,3,2,1,2,2)=XMPHI(2,3,1,2,2,2)
      XMPHI(2,3,2,1,3,3)=XMPHI(2,3,1,2,3,3)
      XMPHI(2,3,2,1,2,3)=XMPHI(2,3,1,2,2,3)
      XMPHI(2,3,2,1,3,2)=XMPHI(2,3,1,2,2,3)
      XMPHI(2,3,2,1,3,1)=XMPHI(2,3,1,2,3,1)
      XMPHI(2,3,2,1,1,3)=XMPHI(2,3,1,2,3,1)
      XMPHI(2,3,2,1,1,2)=XMPHI(2,3,1,2,1,2)
      XMPHI(2,3,2,1,2,1)=XMPHI(2,3,1,2,1,2)
C
      XMPHI(1,2,2,3,1,1)=XMPHI(2,3,1,2,1,1)
      XMPHI(1,2,2,3,2,2)=XMPHI(2,3,1,2,2,2)
      XMPHI(1,2,2,3,3,3)=XMPHI(2,3,1,2,3,3)
      XMPHI(1,2,2,3,2,3)=XMPHI(2,3,1,2,2,3)
      XMPHI(1,2,2,3,3,2)=XMPHI(2,3,1,2,2,3)
      XMPHI(1,2,2,3,3,1)=XMPHI(2,3,1,2,3,1)
      XMPHI(1,2,2,3,1,3)=XMPHI(2,3,1,2,3,1)
      XMPHI(1,2,2,3,1,2)=XMPHI(2,3,1,2,1,2)
      XMPHI(1,2,2,3,2,1)=XMPHI(2,3,1,2,1,2)
C
      XMPHI(1,2,3,2,1,1)=XMPHI(2,3,1,2,1,1)
      XMPHI(1,2,3,2,2,2)=XMPHI(2,3,1,2,2,2)
      XMPHI(1,2,3,2,3,3)=XMPHI(2,3,1,2,3,3)
      XMPHI(1,2,3,2,2,3)=XMPHI(2,3,1,2,2,3)
      XMPHI(1,2,3,2,3,2)=XMPHI(2,3,1,2,2,3)
      XMPHI(1,2,3,2,3,1)=XMPHI(2,3,1,2,3,1)
      XMPHI(1,2,3,2,1,3)=XMPHI(2,3,1,2,3,1)
      XMPHI(1,2,3,2,1,2)=XMPHI(2,3,1,2,1,2)
      XMPHI(1,2,3,2,2,1)=XMPHI(2,3,1,2,1,2)
C
      XMPHI(3,2,1,2,1,1)=XMPHI(2,3,1,2,1,1)
      XMPHI(3,2,1,2,2,2)=XMPHI(2,3,1,2,2,2)
      XMPHI(3,2,1,2,3,3)=XMPHI(2,3,1,2,3,3)
      XMPHI(3,2,1,2,2,3)=XMPHI(2,3,1,2,2,3)
      XMPHI(3,2,1,2,3,2)=XMPHI(2,3,1,2,2,3)
      XMPHI(3,2,1,2,3,1)=XMPHI(2,3,1,2,3,1)
      XMPHI(3,2,1,2,1,3)=XMPHI(2,3,1,2,3,1)
      XMPHI(3,2,1,2,1,2)=XMPHI(2,3,1,2,1,2)
      XMPHI(3,2,1,2,2,1)=XMPHI(2,3,1,2,1,2)
C
      XMPHI(3,2,2,1,1,1)=XMPHI(2,3,1,2,1,1)
      XMPHI(3,2,2,1,2,2)=XMPHI(2,3,1,2,2,2)
      XMPHI(3,2,2,1,3,3)=XMPHI(2,3,1,2,3,3)
      XMPHI(3,2,2,1,2,3)=XMPHI(2,3,1,2,2,3)
      XMPHI(3,2,2,1,3,2)=XMPHI(2,3,1,2,2,3)
      XMPHI(3,2,2,1,3,1)=XMPHI(2,3,1,2,3,1)
      XMPHI(3,2,2,1,1,3)=XMPHI(2,3,1,2,3,1)
      XMPHI(3,2,2,1,1,2)=XMPHI(2,3,1,2,1,2)
      XMPHI(3,2,2,1,2,1)=XMPHI(2,3,1,2,1,2)
C
      XMPHI(2,1,2,3,1,1)=XMPHI(2,3,1,2,1,1)
      XMPHI(2,1,2,3,2,2)=XMPHI(2,3,1,2,2,2)
      XMPHI(2,1,2,3,3,3)=XMPHI(2,3,1,2,3,3)
      XMPHI(2,1,2,3,2,3)=XMPHI(2,3,1,2,2,3)
      XMPHI(2,1,2,3,3,2)=XMPHI(2,3,1,2,2,3)
      XMPHI(2,1,2,3,3,1)=XMPHI(2,3,1,2,3,1)
      XMPHI(2,1,2,3,1,3)=XMPHI(2,3,1,2,3,1)
      XMPHI(2,1,2,3,1,2)=XMPHI(2,3,1,2,1,2)
      XMPHI(2,1,2,3,2,1)=XMPHI(2,3,1,2,1,2)
C
      XMPHI(2,1,3,2,1,1)=XMPHI(2,3,1,2,1,1)
      XMPHI(2,1,3,2,2,2)=XMPHI(2,3,1,2,2,2)
      XMPHI(2,1,3,2,3,3)=XMPHI(2,3,1,2,3,3)
      XMPHI(2,1,3,2,2,3)=XMPHI(2,3,1,2,2,3)
      XMPHI(2,1,3,2,3,2)=XMPHI(2,3,1,2,2,3)
      XMPHI(2,1,3,2,3,1)=XMPHI(2,3,1,2,3,1)
      XMPHI(2,1,3,2,1,3)=XMPHI(2,3,1,2,3,1)
      XMPHI(2,1,3,2,1,2)=XMPHI(2,3,1,2,1,2)
      XMPHI(2,1,3,2,2,1)=XMPHI(2,3,1,2,1,2)
C
C
      XMPHI(1,1,1,2,1,1)=(-X5*D1)/(TWO*DT*DT)
      XMPHI(1,1,1,2,2,2)=(-X5*D2)/(TWO*DT*DT)
      XMPHI(1,1,1,2,3,3)=(-PHI(1,2)*DT-X5*D3)/(TWO*DT*DT)
      XMPHI(1,1,1,2,2,3)=(PHI(1,3)*DT-X5*D4)/(TWO*DT*DT)
      XMPHI(1,1,1,2,3,2)=XMPHI(1,1,1,2,2,3)
      XMPHI(1,1,1,2,3,1)=(PHI(2,3)*DT-X5*D5)/(TWO*DT*DT)
      XMPHI(1,1,1,2,1,3)=XMPHI(1,1,1,2,3,1)
      XMPHI(1,1,1,2,1,2)=(P3*DT-X5*D6)/(TWO*DT*DT)
      XMPHI(1,1,1,2,2,1)=XMPHI(1,1,1,2,1,2)
C
      XMPHI(1,1,2,1,1,1)=XMPHI(1,1,1,2,1,1)
      XMPHI(1,1,2,1,2,2)=XMPHI(1,1,1,2,2,2)
      XMPHI(1,1,2,1,3,3)=XMPHI(1,1,1,2,3,3)
      XMPHI(1,1,2,1,2,3)=XMPHI(1,1,1,2,2,3)
      XMPHI(1,1,2,1,3,2)=XMPHI(1,1,1,2,2,3)
      XMPHI(1,1,2,1,3,1)=XMPHI(1,1,1,2,3,1)
      XMPHI(1,1,2,1,1,3)=XMPHI(1,1,1,2,3,1)
      XMPHI(1,1,2,1,1,2)=XMPHI(1,1,1,2,1,2)
      XMPHI(1,1,2,1,2,1)=XMPHI(1,1,1,2,1,2)
C
      XMPHI(2,2,1,2,1,1)=XMPHI(1,1,1,2,1,1)
      XMPHI(2,2,1,2,2,2)=XMPHI(1,1,1,2,2,2)
      XMPHI(2,2,1,2,3,3)=XMPHI(1,1,1,2,3,3)
      XMPHI(2,2,1,2,2,3)=XMPHI(1,1,1,2,2,3)
      XMPHI(2,2,1,2,3,2)=XMPHI(1,1,1,2,2,3)
      XMPHI(2,2,1,2,3,1)=XMPHI(1,1,1,2,3,1)
      XMPHI(2,2,1,2,1,3)=XMPHI(1,1,1,2,3,1)
      XMPHI(2,2,1,2,1,2)=XMPHI(1,1,1,2,1,2)
      XMPHI(2,2,1,2,2,1)=XMPHI(1,1,1,2,1,2)
C
      XMPHI(2,2,2,1,1,1)=XMPHI(1,1,1,2,1,1)
      XMPHI(2,2,2,1,2,2)=XMPHI(1,1,1,2,2,2)
      XMPHI(2,2,2,1,3,3)=XMPHI(1,1,1,2,3,3)
      XMPHI(2,2,2,1,2,3)=XMPHI(1,1,1,2,2,3)
      XMPHI(2,2,2,1,3,2)=XMPHI(1,1,1,2,2,3)
      XMPHI(2,2,2,1,3,1)=XMPHI(1,1,1,2,3,1)
      XMPHI(2,2,2,1,1,3)=XMPHI(1,1,1,2,3,1)
      XMPHI(2,2,2,1,1,2)=XMPHI(1,1,1,2,1,2)
      XMPHI(2,2,2,1,2,1)=XMPHI(1,1,1,2,1,2)
C
      XMPHI(1,2,1,1,1,1)=XMPHI(1,1,1,2,1,1)
      XMPHI(1,2,1,1,2,2)=XMPHI(1,1,1,2,2,2)
      XMPHI(1,2,1,1,3,3)=XMPHI(1,1,1,2,3,3)
      XMPHI(1,2,1,1,2,3)=XMPHI(1,1,1,2,2,3)
      XMPHI(1,2,1,1,3,2)=XMPHI(1,1,1,2,2,3)
      XMPHI(1,2,1,1,3,1)=XMPHI(1,1,1,2,3,1)
      XMPHI(1,2,1,1,1,3)=XMPHI(1,1,1,2,3,1)
      XMPHI(1,2,1,1,1,2)=XMPHI(1,1,1,2,1,2)
      XMPHI(1,2,1,1,2,1)=XMPHI(1,1,1,2,1,2)
C
      XMPHI(1,2,2,2,1,1)=XMPHI(1,1,1,2,1,1)
      XMPHI(1,2,2,2,2,2)=XMPHI(1,1,1,2,2,2)
      XMPHI(1,2,2,2,3,3)=XMPHI(1,1,1,2,3,3)
      XMPHI(1,2,2,2,2,3)=XMPHI(1,1,1,2,2,3)
      XMPHI(1,2,2,2,3,2)=XMPHI(1,1,1,2,2,3)
      XMPHI(1,2,2,2,3,1)=XMPHI(1,1,1,2,3,1)
      XMPHI(1,2,2,2,1,3)=XMPHI(1,1,1,2,3,1)
      XMPHI(1,2,2,2,1,2)=XMPHI(1,1,1,2,1,2)
      XMPHI(1,2,2,2,2,1)=XMPHI(1,1,1,2,1,2)
C
      XMPHI(2,1,1,1,1,1)=XMPHI(1,1,1,2,1,1)
      XMPHI(2,1,1,1,2,2)=XMPHI(1,1,1,2,2,2)
      XMPHI(2,1,1,1,3,3)=XMPHI(1,1,1,2,3,3)
      XMPHI(2,1,1,1,2,3)=XMPHI(1,1,1,2,2,3)
      XMPHI(2,1,1,1,3,2)=XMPHI(1,1,1,2,2,3)
      XMPHI(2,1,1,1,3,1)=XMPHI(1,1,1,2,3,1)
      XMPHI(2,1,1,1,1,3)=XMPHI(1,1,1,2,3,1)
      XMPHI(2,1,1,1,1,2)=XMPHI(1,1,1,2,1,2)
      XMPHI(2,1,1,1,2,1)=XMPHI(1,1,1,2,1,2)
C
      XMPHI(2,1,2,2,1,1)=XMPHI(1,1,1,2,1,1)
      XMPHI(2,1,2,2,2,2)=XMPHI(1,1,1,2,2,2)
      XMPHI(2,1,2,2,3,3)=XMPHI(1,1,1,2,3,3)
      XMPHI(2,1,2,2,2,3)=XMPHI(1,1,1,2,2,3)
      XMPHI(2,1,2,2,3,2)=XMPHI(1,1,1,2,2,3)
      XMPHI(2,1,2,2,3,1)=XMPHI(1,1,1,2,3,1)
      XMPHI(2,1,2,2,1,3)=XMPHI(1,1,1,2,3,1)
      XMPHI(2,1,2,2,1,2)=XMPHI(1,1,1,2,1,2)
      XMPHI(2,1,2,2,2,1)=XMPHI(1,1,1,2,1,2)
C
C
      XMPHI(2,3,1,3,1,1)=XMPHI(1,1,1,2,1,1)/TWO
      XMPHI(2,3,1,3,2,2)=XMPHI(1,1,1,2,2,2)/TWO
      XMPHI(2,3,1,3,3,3)=XMPHI(1,1,1,2,3,3)/TWO
      XMPHI(2,3,1,3,2,3)=XMPHI(1,1,1,2,2,3)/TWO
      XMPHI(2,3,1,3,3,2)=XMPHI(1,1,1,2,2,3)/TWO
      XMPHI(2,3,1,3,3,1)=XMPHI(1,1,1,2,3,1)/TWO
      XMPHI(2,3,1,3,1,3)=XMPHI(1,1,1,2,3,1)/TWO
      XMPHI(2,3,1,3,1,2)=XMPHI(1,1,1,2,1,2)/TWO
      XMPHI(2,3,1,3,2,1)=XMPHI(1,1,1,2,1,2)/TWO
C
      XMPHI(2,3,3,1,1,1)=XMPHI(2,3,1,3,1,1)
      XMPHI(2,3,3,1,2,2)=XMPHI(2,3,1,3,2,2)
      XMPHI(2,3,3,1,3,3)=XMPHI(2,3,1,3,3,3)
      XMPHI(2,3,3,1,2,3)=XMPHI(2,3,1,3,2,3)
      XMPHI(2,3,3,1,3,2)=XMPHI(2,3,1,3,2,3)
      XMPHI(2,3,3,1,3,1)=XMPHI(2,3,1,3,3,1)
      XMPHI(2,3,3,1,1,3)=XMPHI(2,3,1,3,3,1)
      XMPHI(2,3,3,1,1,2)=XMPHI(2,3,1,3,1,2)
      XMPHI(2,3,3,1,2,1)=XMPHI(2,3,1,3,1,2)
C
      XMPHI(3,1,2,3,1,1)=XMPHI(2,3,1,3,1,1)
      XMPHI(3,1,2,3,2,2)=XMPHI(2,3,1,3,2,2)
      XMPHI(3,1,2,3,3,3)=XMPHI(2,3,1,3,3,3)
      XMPHI(3,1,2,3,2,3)=XMPHI(2,3,1,3,2,3)
      XMPHI(3,1,2,3,3,2)=XMPHI(2,3,1,3,2,3)
      XMPHI(3,1,2,3,3,1)=XMPHI(2,3,1,3,3,1)
      XMPHI(3,1,2,3,1,3)=XMPHI(2,3,1,3,3,1)
      XMPHI(3,1,2,3,1,2)=XMPHI(2,3,1,3,1,2)
      XMPHI(3,1,2,3,2,1)=XMPHI(2,3,1,3,1,2)
C
      XMPHI(3,1,3,2,1,1)=XMPHI(2,3,1,3,1,1)
      XMPHI(3,1,3,2,2,2)=XMPHI(2,3,1,3,2,2)
      XMPHI(3,1,3,2,3,3)=XMPHI(2,3,1,3,3,3)
      XMPHI(3,1,3,2,2,3)=XMPHI(2,3,1,3,2,3)
      XMPHI(3,1,3,2,3,2)=XMPHI(2,3,1,3,2,3)
      XMPHI(3,1,3,2,3,1)=XMPHI(2,3,1,3,3,1)
      XMPHI(3,1,3,2,1,3)=XMPHI(2,3,1,3,3,1)
      XMPHI(3,1,3,2,1,2)=XMPHI(2,3,1,3,1,2)
      XMPHI(3,1,3,2,2,1)=XMPHI(2,3,1,3,1,2)
C
      XMPHI(3,2,1,3,1,1)=XMPHI(2,3,1,3,1,1)
      XMPHI(3,2,1,3,2,2)=XMPHI(2,3,1,3,2,2)
      XMPHI(3,2,1,3,3,3)=XMPHI(2,3,1,3,3,3)
      XMPHI(3,2,1,3,2,3)=XMPHI(2,3,1,3,2,3)
      XMPHI(3,2,1,3,3,2)=XMPHI(2,3,1,3,2,3)
      XMPHI(3,2,1,3,3,1)=XMPHI(2,3,1,3,3,1)
      XMPHI(3,2,1,3,1,3)=XMPHI(2,3,1,3,3,1)
      XMPHI(3,2,1,3,1,2)=XMPHI(2,3,1,3,1,2)
      XMPHI(3,2,1,3,2,1)=XMPHI(2,3,1,3,1,2)
C
      XMPHI(3,2,3,1,1,1)=XMPHI(2,3,1,3,1,1)
      XMPHI(3,2,3,1,2,2)=XMPHI(2,3,1,3,2,2)
      XMPHI(3,2,3,1,3,3)=XMPHI(2,3,1,3,3,3)
      XMPHI(3,2,3,1,2,3)=XMPHI(2,3,1,3,2,3)
      XMPHI(3,2,3,1,3,2)=XMPHI(2,3,1,3,2,3)
      XMPHI(3,2,3,1,3,1)=XMPHI(2,3,1,3,3,1)
      XMPHI(3,2,3,1,1,3)=XMPHI(2,3,1,3,3,1)
      XMPHI(3,2,3,1,1,2)=XMPHI(2,3,1,3,1,2)
      XMPHI(3,2,3,1,2,1)=XMPHI(2,3,1,3,1,2)
C
      XMPHI(1,3,2,3,1,1)=XMPHI(2,3,1,3,1,1)
      XMPHI(1,3,2,3,2,2)=XMPHI(2,3,1,3,2,2)
      XMPHI(1,3,2,3,3,3)=XMPHI(2,3,1,3,3,3)
      XMPHI(1,3,2,3,2,3)=XMPHI(2,3,1,3,2,3)
      XMPHI(1,3,2,3,3,2)=XMPHI(2,3,1,3,2,3)
      XMPHI(1,3,2,3,3,1)=XMPHI(2,3,1,3,3,1)
      XMPHI(1,3,2,3,1,3)=XMPHI(2,3,1,3,3,1)
      XMPHI(1,3,2,3,1,2)=XMPHI(2,3,1,3,1,2)
      XMPHI(1,3,2,3,2,1)=XMPHI(2,3,1,3,1,2)
C
      XMPHI(1,3,3,2,1,1)=XMPHI(2,3,1,3,1,1)
      XMPHI(1,3,3,2,2,2)=XMPHI(2,3,1,3,2,2)
      XMPHI(1,3,3,2,3,3)=XMPHI(2,3,1,3,3,3)
      XMPHI(1,3,3,2,2,3)=XMPHI(2,3,1,3,2,3)
      XMPHI(1,3,3,2,3,2)=XMPHI(2,3,1,3,2,3)
      XMPHI(1,3,3,2,3,1)=XMPHI(2,3,1,3,3,1)
      XMPHI(1,3,3,2,1,3)=XMPHI(2,3,1,3,3,1)
      XMPHI(1,3,3,2,1,2)=XMPHI(2,3,1,3,1,2)
      XMPHI(1,3,3,2,2,1)=XMPHI(2,3,1,3,1,2)
C
C
      XMPHI(2,2,2,3,1,1)=(-PHI(2,3)*DT-X6*D1)/(TWO*DT*DT)
      XMPHI(2,2,2,3,2,2)=(-X6*D2)/(TWO*DT*DT)
      XMPHI(2,2,2,3,3,3)=(-X6*D3)/(TWO*DT*DT)
      XMPHI(2,2,2,3,2,3)=(P1*DT-X6*D4)/(TWO*DT*DT)
      XMPHI(2,2,2,3,3,2)=XMPHI(2,2,2,3,2,3)
      XMPHI(2,2,2,3,1,3)=(PHI(1,2)*DT-X6*D5)/(TWO*DT*DT)
      XMPHI(2,2,2,3,3,1)=XMPHI(2,2,2,3,1,3)
      XMPHI(2,2,2,3,1,2)=(PHI(1,3)*DT-X6*D6)/(TWO*DT*DT)
      XMPHI(2,2,2,3,2,1)=XMPHI(2,2,2,3,1,2)
C
      XMPHI(2,2,3,2,1,1)=XMPHI(2,2,2,3,1,1)
      XMPHI(2,2,3,2,2,2)=XMPHI(2,2,2,3,2,2)
      XMPHI(2,2,3,2,3,3)=XMPHI(2,2,2,3,3,3)
      XMPHI(2,2,3,2,2,3)=XMPHI(2,2,2,3,2,3)
      XMPHI(2,2,3,2,3,2)=XMPHI(2,2,2,3,2,3)
      XMPHI(2,2,3,2,1,3)=XMPHI(2,2,2,3,1,3)
      XMPHI(2,2,3,2,3,1)=XMPHI(2,2,2,3,1,3)
      XMPHI(2,2,3,2,1,2)=XMPHI(2,2,2,3,1,2)
      XMPHI(2,2,3,2,2,1)=XMPHI(2,2,2,3,1,2)
C
      XMPHI(3,3,2,3,1,1)=XMPHI(2,2,2,3,1,1)
      XMPHI(3,3,2,3,2,2)=XMPHI(2,2,2,3,2,2)
      XMPHI(3,3,2,3,3,3)=XMPHI(2,2,2,3,3,3)
      XMPHI(3,3,2,3,2,3)=XMPHI(2,2,2,3,2,3)
      XMPHI(3,3,2,3,3,2)=XMPHI(2,2,2,3,2,3)
      XMPHI(3,3,2,3,1,3)=XMPHI(2,2,2,3,1,3)
      XMPHI(3,3,2,3,3,1)=XMPHI(2,2,2,3,1,3)
      XMPHI(3,3,2,3,1,2)=XMPHI(2,2,2,3,1,2)
      XMPHI(3,3,2,3,2,1)=XMPHI(2,2,2,3,1,2)
C
      XMPHI(3,3,3,2,1,1)=XMPHI(2,2,2,3,1,1)
      XMPHI(3,3,3,2,2,2)=XMPHI(2,2,2,3,2,2)
      XMPHI(3,3,3,2,3,3)=XMPHI(2,2,2,3,3,3)
      XMPHI(3,3,3,2,2,3)=XMPHI(2,2,2,3,2,3)
      XMPHI(3,3,3,2,3,2)=XMPHI(2,2,2,3,2,3)
      XMPHI(3,3,3,2,1,3)=XMPHI(2,2,2,3,1,3)
      XMPHI(3,3,3,2,3,1)=XMPHI(2,2,2,3,1,3)
      XMPHI(3,3,3,2,1,2)=XMPHI(2,2,2,3,1,2)
      XMPHI(3,3,3,2,2,1)=XMPHI(2,2,2,3,1,2)
C
      XMPHI(2,3,2,2,1,1)=XMPHI(2,2,2,3,1,1)
      XMPHI(2,3,2,2,2,2)=XMPHI(2,2,2,3,2,2)
      XMPHI(2,3,2,2,3,3)=XMPHI(2,2,2,3,3,3)
      XMPHI(2,3,2,2,2,3)=XMPHI(2,2,2,3,2,3)
      XMPHI(2,3,2,2,3,2)=XMPHI(2,2,2,3,2,3)
      XMPHI(2,3,2,2,1,3)=XMPHI(2,2,2,3,1,3)
      XMPHI(2,3,2,2,3,1)=XMPHI(2,2,2,3,1,3)
      XMPHI(2,3,2,2,1,2)=XMPHI(2,2,2,3,1,2)
      XMPHI(2,3,2,2,2,1)=XMPHI(2,2,2,3,1,2)
C
      XMPHI(2,3,3,3,1,1)=XMPHI(2,2,2,3,1,1)
      XMPHI(2,3,3,3,2,2)=XMPHI(2,2,2,3,2,2)
      XMPHI(2,3,3,3,3,3)=XMPHI(2,2,2,3,3,3)
      XMPHI(2,3,3,3,2,3)=XMPHI(2,2,2,3,2,3)
      XMPHI(2,3,3,3,3,2)=XMPHI(2,2,2,3,2,3)
      XMPHI(2,3,3,3,1,3)=XMPHI(2,2,2,3,1,3)
      XMPHI(2,3,3,3,3,1)=XMPHI(2,2,2,3,1,3)
      XMPHI(2,3,3,3,1,2)=XMPHI(2,2,2,3,1,2)
      XMPHI(2,3,3,3,2,1)=XMPHI(2,2,2,3,1,2)
C
      XMPHI(3,2,2,2,1,1)=XMPHI(2,2,2,3,1,1)
      XMPHI(3,2,2,2,2,2)=XMPHI(2,2,2,3,2,2)
      XMPHI(3,2,2,2,3,3)=XMPHI(2,2,2,3,3,3)
      XMPHI(3,2,2,2,2,3)=XMPHI(2,2,2,3,2,3)
      XMPHI(3,2,2,2,3,2)=XMPHI(2,2,2,3,2,3)
      XMPHI(3,2,2,2,1,3)=XMPHI(2,2,2,3,1,3)
      XMPHI(3,2,2,2,3,1)=XMPHI(2,2,2,3,1,3)
      XMPHI(3,2,2,2,1,2)=XMPHI(2,2,2,3,1,2)
      XMPHI(3,2,2,2,2,1)=XMPHI(2,2,2,3,1,2)
C
      XMPHI(3,2,3,3,1,1)=XMPHI(2,2,2,3,1,1)
      XMPHI(3,2,3,3,2,2)=XMPHI(2,2,2,3,2,2)
      XMPHI(3,2,3,3,3,3)=XMPHI(2,2,2,3,3,3)
      XMPHI(3,2,3,3,2,3)=XMPHI(2,2,2,3,2,3)
      XMPHI(3,2,3,3,3,2)=XMPHI(2,2,2,3,2,3)
      XMPHI(3,2,3,3,1,3)=XMPHI(2,2,2,3,1,3)
      XMPHI(3,2,3,3,3,1)=XMPHI(2,2,2,3,1,3)
      XMPHI(3,2,3,3,1,2)=XMPHI(2,2,2,3,1,2)
      XMPHI(3,2,3,3,2,1)=XMPHI(2,2,2,3,1,2)
C
C
      XMPHI(3,1,1,2,1,1)=XMPHI(2,2,2,3,1,1)/TWO
      XMPHI(3,1,1,2,2,2)=XMPHI(2,2,2,3,2,2)/TWO
      XMPHI(3,1,1,2,3,3)=XMPHI(2,2,2,3,3,3)/TWO
      XMPHI(3,1,1,2,2,3)=XMPHI(2,2,2,3,2,3)/TWO
      XMPHI(3,1,1,2,3,2)=XMPHI(2,2,2,3,2,3)/TWO
      XMPHI(3,1,1,2,1,3)=XMPHI(2,2,2,3,1,3)/TWO
      XMPHI(3,1,1,2,3,1)=XMPHI(2,2,2,3,1,3)/TWO
      XMPHI(3,1,1,2,1,2)=XMPHI(2,2,2,3,1,2)/TWO
      XMPHI(3,1,1,2,2,1)=XMPHI(2,2,2,3,1,2)/TWO
C
      XMPHI(3,1,2,1,1,1)=XMPHI(3,1,1,2,1,1)
      XMPHI(3,1,2,1,2,2)=XMPHI(3,1,1,2,2,2)
      XMPHI(3,1,2,1,3,3)=XMPHI(3,1,1,2,3,3)
      XMPHI(3,1,2,1,2,3)=XMPHI(3,1,1,2,2,3)
      XMPHI(3,1,2,1,3,2)=XMPHI(3,1,1,2,2,3)
      XMPHI(3,1,2,1,1,3)=XMPHI(3,1,1,2,1,3)
      XMPHI(3,1,2,1,3,1)=XMPHI(3,1,1,2,1,3)
      XMPHI(3,1,2,1,1,2)=XMPHI(3,1,1,2,1,2)
      XMPHI(3,1,2,1,2,1)=XMPHI(3,1,1,2,1,2)
C
      XMPHI(1,2,1,3,1,1)=XMPHI(3,1,1,2,1,1)
      XMPHI(1,2,1,3,2,2)=XMPHI(3,1,1,2,2,2)
      XMPHI(1,2,1,3,3,3)=XMPHI(3,1,1,2,3,3)
      XMPHI(1,2,1,3,2,3)=XMPHI(3,1,1,2,2,3)
      XMPHI(1,2,1,3,3,2)=XMPHI(3,1,1,2,2,3)
      XMPHI(1,2,1,3,1,3)=XMPHI(3,1,1,2,1,3)
      XMPHI(1,2,1,3,3,1)=XMPHI(3,1,1,2,1,3)
      XMPHI(1,2,1,3,1,2)=XMPHI(3,1,1,2,1,2)
      XMPHI(1,2,1,3,2,1)=XMPHI(3,1,1,2,1,2)
C
      XMPHI(1,2,3,1,1,1)=XMPHI(3,1,1,2,1,1)
      XMPHI(1,2,3,1,2,2)=XMPHI(3,1,1,2,2,2)
      XMPHI(1,2,3,1,3,3)=XMPHI(3,1,1,2,3,3)
      XMPHI(1,2,3,1,2,3)=XMPHI(3,1,1,2,2,3)
      XMPHI(1,2,3,1,3,2)=XMPHI(3,1,1,2,2,3)
      XMPHI(1,2,3,1,1,3)=XMPHI(3,1,1,2,1,3)
      XMPHI(1,2,3,1,3,1)=XMPHI(3,1,1,2,1,3)
      XMPHI(1,2,3,1,1,2)=XMPHI(3,1,1,2,1,2)
      XMPHI(1,2,3,1,2,1)=XMPHI(3,1,1,2,1,2)
C
      XMPHI(1,3,1,2,1,1)=XMPHI(3,1,1,2,1,1)
      XMPHI(1,3,1,2,2,2)=XMPHI(3,1,1,2,2,2)
      XMPHI(1,3,1,2,3,3)=XMPHI(3,1,1,2,3,3)
      XMPHI(1,3,1,2,2,3)=XMPHI(3,1,1,2,2,3)
      XMPHI(1,3,1,2,3,2)=XMPHI(3,1,1,2,2,3)
      XMPHI(1,3,1,2,1,3)=XMPHI(3,1,1,2,1,3)
      XMPHI(1,3,1,2,3,1)=XMPHI(3,1,1,2,1,3)
      XMPHI(1,3,1,2,1,2)=XMPHI(3,1,1,2,1,2)
      XMPHI(1,3,1,2,2,1)=XMPHI(3,1,1,2,1,2)
C
      XMPHI(1,3,2,1,1,1)=XMPHI(3,1,1,2,1,1)
      XMPHI(1,3,2,1,2,2)=XMPHI(3,1,1,2,2,2)
      XMPHI(1,3,2,1,3,3)=XMPHI(3,1,1,2,3,3)
      XMPHI(1,3,2,1,2,3)=XMPHI(3,1,1,2,2,3)
      XMPHI(1,3,2,1,3,2)=XMPHI(3,1,1,2,2,3)
      XMPHI(1,3,2,1,1,3)=XMPHI(3,1,1,2,1,3)
      XMPHI(1,3,2,1,3,1)=XMPHI(3,1,1,2,1,3)
      XMPHI(1,3,2,1,1,2)=XMPHI(3,1,1,2,1,2)
      XMPHI(1,3,2,1,2,1)=XMPHI(3,1,1,2,1,2)
C
      XMPHI(2,1,1,3,1,1)=XMPHI(3,1,1,2,1,1)
      XMPHI(2,1,1,3,2,2)=XMPHI(3,1,1,2,2,2)
      XMPHI(2,1,1,3,3,3)=XMPHI(3,1,1,2,3,3)
      XMPHI(2,1,1,3,2,3)=XMPHI(3,1,1,2,2,3)
      XMPHI(2,1,1,3,3,2)=XMPHI(3,1,1,2,2,3)
      XMPHI(2,1,1,3,1,3)=XMPHI(3,1,1,2,1,3)
      XMPHI(2,1,1,3,3,1)=XMPHI(3,1,1,2,1,3)
      XMPHI(2,1,1,3,1,2)=XMPHI(3,1,1,2,1,2)
      XMPHI(2,1,1,3,2,1)=XMPHI(3,1,1,2,1,2)
C
      XMPHI(2,1,3,1,1,1)=XMPHI(3,1,1,2,1,1)
      XMPHI(2,1,3,1,2,2)=XMPHI(3,1,1,2,2,2)
      XMPHI(2,1,3,1,3,3)=XMPHI(3,1,1,2,3,3)
      XMPHI(2,1,3,1,2,3)=XMPHI(3,1,1,2,2,3)
      XMPHI(2,1,3,1,3,2)=XMPHI(3,1,1,2,2,3)
      XMPHI(2,1,3,1,1,3)=XMPHI(3,1,1,2,1,3)
      XMPHI(2,1,3,1,3,1)=XMPHI(3,1,1,2,1,3)
      XMPHI(2,1,3,1,1,2)=XMPHI(3,1,1,2,1,2)
      XMPHI(2,1,3,1,2,1)=XMPHI(3,1,1,2,1,2)
C
C
      XMPHI(2,3,2,3,1,1)=((-P3-P2)*DT-X7*D1)/(FOUR*DT*DT)
      XMPHI(2,3,2,3,2,2)=(-P1*DT-X7*D2)/(FOUR*DT*DT)
      XMPHI(2,3,2,3,3,3)=(-P1*DT-X7*D3)/(FOUR*DT*DT)
      XMPHI(2,3,2,3,2,3)=(-X7*D4)/(FOUR*DT*DT)
      XMPHI(2,3,2,3,3,2)=XMPHI(2,3,2,3,2,3)
      XMPHI(2,3,2,3,1,3)=(-TWO*PHI(1,3)*DT-X7*D5)/(FOUR*DT*DT)
      XMPHI(2,3,2,3,3,1)=XMPHI(2,3,2,3,1,3)
      XMPHI(2,3,2,3,1,2)=(-TWO*PHI(1,2)*DT-X7*D6)/(FOUR*DT*DT)
      XMPHI(2,3,2,3,2,1)=XMPHI(2,3,2,3,1,2)
C
      XMPHI(2,3,3,2,1,1)=XMPHI(2,3,2,3,1,1)
      XMPHI(2,3,3,2,2,2)=XMPHI(2,3,2,3,2,2)
      XMPHI(2,3,3,2,3,3)=XMPHI(2,3,2,3,3,3)
      XMPHI(2,3,3,2,2,3)=XMPHI(2,3,2,3,2,3)
      XMPHI(2,3,3,2,3,2)=XMPHI(2,3,2,3,2,3)
      XMPHI(2,3,3,2,1,3)=XMPHI(2,3,2,3,1,3)
      XMPHI(2,3,3,2,3,1)=XMPHI(2,3,2,3,1,3)
      XMPHI(2,3,3,2,1,2)=XMPHI(2,3,2,3,1,2)
      XMPHI(2,3,3,2,2,1)=XMPHI(2,3,2,3,1,2)
C
      XMPHI(3,2,2,3,1,1)=XMPHI(2,3,2,3,1,1)
      XMPHI(3,2,2,3,2,2)=XMPHI(2,3,2,3,2,2)
      XMPHI(3,2,2,3,3,3)=XMPHI(2,3,2,3,3,3)
      XMPHI(3,2,2,3,2,3)=XMPHI(2,3,2,3,2,3)
      XMPHI(3,2,2,3,3,2)=XMPHI(2,3,2,3,2,3)
      XMPHI(3,2,2,3,1,3)=XMPHI(2,3,2,3,1,3)
      XMPHI(3,2,2,3,3,1)=XMPHI(2,3,2,3,1,3)
      XMPHI(3,2,2,3,1,2)=XMPHI(2,3,2,3,1,2)
      XMPHI(3,2,2,3,2,1)=XMPHI(2,3,2,3,1,2)
C
      XMPHI(3,2,3,2,1,1)=XMPHI(2,3,2,3,1,1)
      XMPHI(3,2,3,2,2,2)=XMPHI(2,3,2,3,2,2)
      XMPHI(3,2,3,2,3,3)=XMPHI(2,3,2,3,3,3)
      XMPHI(3,2,3,2,2,3)=XMPHI(2,3,2,3,2,3)
      XMPHI(3,2,3,2,3,2)=XMPHI(2,3,2,3,2,3)
      XMPHI(3,2,3,2,1,3)=XMPHI(2,3,2,3,1,3)
      XMPHI(3,2,3,2,3,1)=XMPHI(2,3,2,3,1,3)
      XMPHI(3,2,3,2,1,2)=XMPHI(2,3,2,3,1,2)
      XMPHI(3,2,3,2,2,1)=XMPHI(2,3,2,3,1,2)
C
C
      XMPHI(3,1,1,3,1,1)=(-P2*DT-X8*D1)/(FOUR*DT*DT)
      XMPHI(3,1,1,3,2,2)=((-P3-P1)*DT-X8*D2)/(FOUR*DT*DT)
      XMPHI(3,1,1,3,3,3)=(-P2*DT-X8*D3)/(FOUR*DT*DT)
      XMPHI(3,1,1,3,2,3)=(-TWO*PHI(2,3)*DT-X8*D4)/(FOUR*DT*DT)
      XMPHI(3,1,1,3,3,2)=XMPHI(3,1,1,3,2,3)
      XMPHI(3,1,1,3,1,3)=(-X8*D5)/(FOUR*DT*DT)
      XMPHI(3,1,1,3,3,1)=XMPHI(3,1,1,3,1,3)
      XMPHI(3,1,1,3,1,2)=(-TWO*PHI(1,2)*DT-X8*D6)/(FOUR*DT*DT)
      XMPHI(3,1,1,3,2,1)=XMPHI(3,1,1,3,1,2)
C
      XMPHI(3,1,3,1,1,1)=XMPHI(3,1,1,3,1,1)
      XMPHI(3,1,3,1,2,2)=XMPHI(3,1,1,3,2,2)
      XMPHI(3,1,3,1,3,3)=XMPHI(3,1,1,3,3,3)
      XMPHI(3,1,3,1,2,3)=XMPHI(3,1,1,3,2,3)
      XMPHI(3,1,3,1,3,2)=XMPHI(3,1,1,3,2,3)
      XMPHI(3,1,3,1,1,3)=XMPHI(3,1,1,3,1,3)
      XMPHI(3,1,3,1,3,1)=XMPHI(3,1,1,3,1,3)
      XMPHI(3,1,3,1,1,2)=XMPHI(3,1,1,3,1,2)
      XMPHI(3,1,3,1,2,1)=XMPHI(3,1,1,3,1,2)
C
      XMPHI(1,3,1,3,1,1)=XMPHI(3,1,1,3,1,1)
      XMPHI(1,3,1,3,2,2)=XMPHI(3,1,1,3,2,2)
      XMPHI(1,3,1,3,3,3)=XMPHI(3,1,1,3,3,3)
      XMPHI(1,3,1,3,2,3)=XMPHI(3,1,1,3,2,3)
      XMPHI(1,3,1,3,3,2)=XMPHI(3,1,1,3,2,3)
      XMPHI(1,3,1,3,1,3)=XMPHI(3,1,1,3,1,3)
      XMPHI(1,3,1,3,3,1)=XMPHI(3,1,1,3,1,3)
      XMPHI(1,3,1,3,1,2)=XMPHI(3,1,1,3,1,2)
      XMPHI(1,3,1,3,2,1)=XMPHI(3,1,1,3,1,2)
C
      XMPHI(1,3,3,1,1,1)=XMPHI(3,1,1,3,1,1)
      XMPHI(1,3,3,1,2,2)=XMPHI(3,1,1,3,2,2)
      XMPHI(1,3,3,1,3,3)=XMPHI(3,1,1,3,3,3)
      XMPHI(1,3,3,1,2,3)=XMPHI(3,1,1,3,2,3)
      XMPHI(1,3,3,1,3,2)=XMPHI(3,1,1,3,2,3)
      XMPHI(1,3,3,1,1,3)=XMPHI(3,1,1,3,1,3)
      XMPHI(1,3,3,1,3,1)=XMPHI(3,1,1,3,1,3)
      XMPHI(1,3,3,1,1,2)=XMPHI(3,1,1,3,1,2)
      XMPHI(1,3,3,1,2,1)=XMPHI(3,1,1,3,1,2)
C
C
      XMPHI(1,2,1,2,1,1)=(-P3*DT-X9*D1)/(FOUR*DT*DT)
      XMPHI(1,2,1,2,2,2)=(-P3*DT-X9*D2)/(FOUR*DT*DT)
      XMPHI(1,2,1,2,3,3)=((-P2-P1)*DT-X9*D3)/(FOUR*DT*DT)
      XMPHI(1,2,1,2,2,3)=(-TWO*PHI(2,3)*DT-X9*D4)/(FOUR*DT*DT)
      XMPHI(1,2,1,2,3,2)=XMPHI(1,2,1,2,2,3)
      XMPHI(1,2,1,2,1,3)=(-TWO*PHI(1,3)*DT-X9*D5)/(FOUR*DT*DT)
      XMPHI(1,2,1,2,3,1)=XMPHI(1,2,1,2,1,3)
      XMPHI(1,2,1,2,1,2)=(-X9*D6)/(FOUR*DT*DT)
      XMPHI(1,2,1,2,2,1)=XMPHI(1,2,1,2,1,2)
C
      XMPHI(1,2,2,1,1,1)=XMPHI(1,2,1,2,1,1)
      XMPHI(1,2,2,1,2,2)=XMPHI(1,2,1,2,2,2)
      XMPHI(1,2,2,1,3,3)=XMPHI(1,2,1,2,3,3)
      XMPHI(1,2,2,1,2,3)=XMPHI(1,2,1,2,2,3)
      XMPHI(1,2,2,1,3,2)=XMPHI(1,2,1,2,2,3)
      XMPHI(1,2,2,1,1,3)=XMPHI(1,2,1,2,1,3)
      XMPHI(1,2,2,1,3,1)=XMPHI(1,2,1,2,1,3)
      XMPHI(1,2,2,1,1,2)=XMPHI(1,2,1,2,1,2)
      XMPHI(1,2,2,1,2,1)=XMPHI(1,2,1,2,1,2)
C
      XMPHI(2,1,1,2,1,1)=XMPHI(1,2,1,2,1,1)
      XMPHI(2,1,1,2,2,2)=XMPHI(1,2,1,2,2,2)
      XMPHI(2,1,1,2,3,3)=XMPHI(1,2,1,2,3,3)
      XMPHI(2,1,1,2,2,3)=XMPHI(1,2,1,2,2,3)
      XMPHI(2,1,1,2,3,2)=XMPHI(1,2,1,2,2,3)
      XMPHI(2,1,1,2,1,3)=XMPHI(1,2,1,2,1,3)
      XMPHI(2,1,1,2,3,1)=XMPHI(1,2,1,2,1,3)
      XMPHI(2,1,1,2,1,2)=XMPHI(1,2,1,2,1,2)
      XMPHI(2,1,1,2,2,1)=XMPHI(1,2,1,2,1,2)
C
      XMPHI(2,1,2,1,1,1)=XMPHI(1,2,1,2,1,1)
      XMPHI(2,1,2,1,2,2)=XMPHI(1,2,1,2,2,2)
      XMPHI(2,1,2,1,3,3)=XMPHI(1,2,1,2,3,3)
      XMPHI(2,1,2,1,2,3)=XMPHI(1,2,1,2,2,3)
      XMPHI(2,1,2,1,3,2)=XMPHI(1,2,1,2,2,3)
      XMPHI(2,1,2,1,1,3)=XMPHI(1,2,1,2,1,3)
      XMPHI(2,1,2,1,3,1)=XMPHI(1,2,1,2,1,3)
      XMPHI(2,1,2,1,1,2)=XMPHI(1,2,1,2,1,2)
      XMPHI(2,1,2,1,2,1)=XMPHI(1,2,1,2,1,2)
C
C EVALUATE THE CONTRACTION M(R,R,K,L)
C
      CALL DAmmij(XM,XMRR)
C
C
      END
 
